rule buhtrap_dll {

meta:

	author = "Curt Wilson"
	Organization = "Arbor ASERT"
	Malware = "Buhtrap"
	Filetype = "DLL"
	SHA256 = "4ea1dfd99f8b03717248b7d53e76edbcf104b4411a89150b85c75ed1e585a4ad"
	version = "1.0"

strings:

	$s1  = "uninstall.log"
	$s2  = "%s: detected MZ signature"
	$s3  = "%s: wszTarget=[%ws]"
	$s4  = "%s: ERR: CreateProcess() failure %04Xh"
	$s5  = "%s: Detected LD signature, loading diskless"
	$s6  = "%s: loaded module at %04Xh, EP=%04Xh"
	$s7  = "%s: created thread to call DllMain, tid=%u"
	$s8  = "%s: ERR: no MZ or LD signature, have %04Xh"
	$s9  = "%s: adding report.."
	$s10 = "%s: cs entered, dwLoggedDataSize=%u"
	$s11 = "%s: WARN: too long clipboard data discarded"
	$s12 = "[clp bgn]"
	$s13 = "[clp end]"
	$s14 = "%s: log file opened, path=[%ws]"
	$s15 = "%s: InetSendRequest() failed in attempt to send %u bytes, err code %04Xh"
	$s16 = "%s: some failure, changing proxy flag to %u and performing re-init, new dwSendFailureCount=%u"
	$s17 = "%s: failed to query SCardStatus() for index %u err code %04Xh (%u)"
	$s18 = "%s: hash check failed, write log, struc len %u data len"
	$s19 = "%s: size query failed, possibly UAC not supported (err %04Xh)"
	$s20 = "%s: storageArray=%04Xh binStorage=%04Xh size=%u"

condition:

	uint16(0) == 0x5a4d and filesize < 256KB and 15 of ($s*)

}




